
##############################
# Country definition for ITA #
##############################

province =
{ id         = 368
  ic         = 6
  anti_air   = 1
  landfort   = 3
  naval_base = { size = 2 current_size = 2 }
  air_base   = { size = 4 current_size = 4 }
}              # Genoa
province =
{ id         = 369
  anti_air   = 1
  naval_base = { size = 10 current_size = 10 }
  air_base   = { size = 4 current_size = 4 }
}              # La Spezia
province =
{ id       = 370
  anti_air = 1
  landfort = 1
  air_base = { size = 4 current_size = 4 }
}            # Milan
province =
{ id       = 371
  landfort = 3
  air_base = { size = 4 current_size = 4 }
}            # Trento
province =
{ id         = 378
  anti_air   = 1
  landfort   = 4
  naval_base = { size = 4 current_size = 4 }
  air_base   = { size = 4 current_size = 4 }
}              # Venice
province = { id = 379 ic = 1 } # Ferrara
province =
{ id         = 399
  air_base   = { size = 1 current_size = 1 }
  oilpool    = 100
  supplypool = 500
}              # Rhodes
province = { id = 512 anti_air = 1 } # Bologna
province = { id = 513 ic = 2 coastalfort = 1 anti_air = 1 } # Florence
province = { id = 514 coastalfort = 1 anti_air = 1 } # Rimini
province =
{ id       = 515
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Rome
province = { id = 516 ic = 3 } # Perugia
province =
{ id       = 520
  air_base = { size = 4 current_size = 4 }
}            # Foggia
province =
{ id         = 521
  air_base   = { size = 2 current_size = 2 }
  naval_base = { size = 4 current_size = 4 }
}              # Naples
province =
{ id          = 523
  ic          = 1
  anti_air    = 1
  coastalfort = 1
  naval_base  = { size = 10 current_size = 10 }
  air_base    = { size = 2 current_size = 2 }
}               # Taranto
province =
{ id          = 525
  coastalfort = 1
  naval_base  = { size = 1 current_size = 1 }
  air_base    = { size = 2 current_size = 2 }
}               # Palermo
province = { id = 526 coastalfort = 1 } # Catania
province =
{ id       = 531
  ic       = 3
  anti_air = 1
  landfort = 3
  air_base = { size = 4 current_size = 4 }
}            # Turin
province =
{ id          = 534
  coastalfort = 1
  naval_base  = { size = 2 current_size = 2 }
  air_base    = { size = 2 current_size = 2 }
  oilpool     = 100
  supplypool  = 500
}               # Sardinia
province =
{ id         = 919
  landfort   = 3
  naval_base = { size = 2 current_size = 2 }
  air_base   = { size = 2 current_size = 2 }
}              # Tobruk
province =
{ id         = 924
  naval_base = { size = 1 current_size = 1 }
  air_base   = { size = 4 current_size = 4 }
}              # Bengazi
province =
{ id         = 932
  naval_base = { size = 1 current_size = 1 }
  air_base   = { size = 2 current_size = 2 }
  oilpool    = 100
  supplypool = 500
}              # Tripoli
province =
{ id         = 1033
  naval_base = { size = 2 current_size = 2 }
  air_base   = { size = 2 current_size = 2 }
  oilpool    = 100
  supplypool = 500
}              # Massaua
province =
{ id         = 1038
  naval_base = { size = 1 current_size = 1 }
  air_base   = { size = 1 current_size = 1 }
  oilpool    = 100
  supplypool = 500
}              # Assab
province = { id = 1056 oilpool = 100 supplypool = 500 } # Mogadishu

#####################
# Country main data #
#####################

country =
{ tag                    = ITA
  manpower               = 460
  # Resource Reserves (set to 6 months imports for energy, metal and rares)
  energy                 = 18720
  metal                  = 9900
  rare_materials         = 2340
  oil                    = 1000
  supplies               = 500
  money                  = 100
  capital                = 515
  belligerence           = 5
  ai                     = "ITA_1936.ai"
  transports             = 200 # 3.5 million tons = one sixth of UK
  escorts                = 35
  policy =
  { date              = { year = 0 month = january day = 0 }
    democratic        = 2
    political_left    = 3
    freedom           = 4
    free_market       = 5 # state sponsored cartels
    professional_army = 3
    defense_lobby     = 7
    interventionism   = 9
  }
  SpyInfo                = { country = "ITA" NumberOfSpies = 8 }
  #SpyInfo                = { country = "ENG" NumberOfSpies = 8 }
  #SpyInfo                = { country = "FRA" NumberOfSpies = 9 }
  #SpyInfo                = { country = "SOV" NumberOfSpies = 6 }
  #SpyInfo                = { country = "CZE" NumberOfSpies = 6 }
  #SpyInfo                = { country = "AUS" NumberOfSpies = 8 }
  #SpyInfo                = { country = "SPR" NumberOfSpies = 8 }
  #SpyInfo                = { country = "POL" NumberOfSpies = 6 }
  #SpyInfo                = { country = "SWE" NumberOfSpies = 3 }
  #SpyInfo                = { country = "NOR" NumberOfSpies = 3 }
  #SpyInfo                = { country = "FIN" NumberOfSpies = 3 }
  #SpyInfo                = { country = "YUG" NumberOfSpies = 9 }
  #SpyInfo                = { country = "HUN" NumberOfSpies = 6 }
  #SpyInfo                = { country = "BUL" NumberOfSpies = 6 }
  #SpyInfo                = { country = "BEL" NumberOfSpies = 3 }
  #SpyInfo                = { country = "DEN" NumberOfSpies = 3 }
  #SpyInfo                = { country = "HOL" NumberOfSpies = 3 }
  #SpyInfo                = { country = "ARG" NumberOfSpies = 8 }
  #SpyInfo                = { country = "USA" NumberOfSpies = 8 }
  #SpyInfo                = { country = "ALB" NumberOfSpies = 6 }
  #SpyInfo                = { country = "GRE" NumberOfSpies = 3 }
  #SpyInfo                = { country = "JAP" NumberOfSpies = 3 }
  #SpyInfo                = { country = "ROM" NumberOfSpies = 3 }
  #SpyInfo                = { country = "TUR" NumberOfSpies = 9 }
  #SpyInfo                = { country = "POR" NumberOfSpies = 3 }
  #SpyInfo                = { country = "GER" NumberOfSpies = 8 }
  nationalprovinces      = { 525 526 524 523 522 521 520 519 518 517 516 515 513 514 512 379 369 368 531 370 371 378 534 381 384 387 388 389 }
  ownedprovinces         = { 525  526  524  523  522  521  520  519  518  517  516  515  513  514  512  379  369  368  531  370  371  378  534  398 
                             399  927  933  932  930  929  925  924  923  922  921  920  919  916  917  918  926  928  931  1017 1018 1016 1015 1033
                             1039 1038 1034 1055 1056 1058 1044 1048 1049 1042 1043 1050 1045 1046 1047 1053 1052 1051 1054
                           }
  controlledprovinces    = { 525  526  524  523  522  521  520  519  518  517  516  515  513  514  512  379  369  368  531  370  371  378  534  398 
                             399  927  933  932  930  929  925  924  923  922  921  920  919  916  917  918  926  928  931  1017 1018 1016 1015 1033
                             1039 1038 1034 1055 1056 1058 1044 1048 1049 1042 1043 1050 1045 1046 1047 1053 1052 1051 1054
                           }
  # Great War Infantry
  techapps               = { 1010  1020  1070  1110  1190  1200  1210  1220  1230  2010  2020  2030  2150  2290  2300  2310  2320  2330  2400  2450 
                             2460  2510  3010  3020  3030  3070  3080  3090  3100  3130  3140  3150  3190  3200  3210  3250  3260  3270  3280  3320 
                             3330  3400  3410  3420  4010  4020  4050  4120  4130  4170  4250  5010  5050  5080  5090  5190  5200  5310  5320  5470 
                             5480  6210  8020  8040  8050  9010  9020  9030  9040  9050  9140  14000 14010
                           }
  # Illyrian Coast
  diplomacy =
  { relation = { tag = AFG value = 50 }
    relation = { tag = ALB value = 10 }
    relation = { tag = ARG value = 30 }
    relation = { tag = AST value = -10 }
    relation = { tag = BEL value = -5 }
    relation = { tag = BHU value = -10 }
    relation = { tag = BUL value = 150 }
    relation = { tag = CAN value = -10 }
    relation = { tag = CHL value = 30 }
    relation = { tag = ENG value = -50 }
    relation = { tag = FIN value = 50 }
    relation = { tag = FRA value = -100 }
    relation = { tag = GER value = 100 }
    relation = { tag = GRE value = -100 }
    relation = { tag = HOL value = -20 }
    relation = { tag = HUN value = 125 }
    relation = { tag = IRQ value = 25 }
    relation = { tag = NEP value = -10 }
    relation = { tag = NZL value = -10 }
    relation = { tag = OMN value = 50 }
    relation = { tag = POR value = 65 }
    relation = { tag = ROM value = 50 }
    relation = { tag = SAF value = -50 }
    relation = { tag = SAU value = -25 }
    relation =
    { tag        = SCH
      value      = 1
      guaranteed = { day = 16 month = may year = 1935 }
    }
    relation =
    { tag        = SPA
      value      = 50
      guaranteed = { day = 18 month = november year = 1936 }
    }
    relation = { tag = TUR value = 1 }
    relation = { tag = YEM value = 50 }
    relation = { tag = YUG value = 75 }
  }
  headofstate            = { type = 9 id = 3001 }
  headofgovernment       = { type = 9 id = 3002 }
  foreignminister        = { type = 9 id = 3003 }
  armamentminister       = { type = 9 id = 3004 }
  ministerofsecurity     = { type = 9 id = 3005 }
  ministerofintelligence = { type = 9 id = 3006 }
  chiefofstaff           = { type = 9 id = 3007 }
  chiefofarmy            = { type = 9 id = 3008 }
  chiefofnavy            = { type = 9 id = 3009 }
  chiefofair             = { type = 9 id = 3010 }
  landunit =
  { location = 531 # Torino
    name     = "1žII "
    id       = { type = 30026 id = 1 }
    division =
    { id           = { type = 30026 id = 2 }
      name         = "4'άŵ'ʦ "
      type         = infantry
      strength     = 70
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 3 }
      name         = "33''ʦ "
      type         = infantry
      strength     = 56
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 4 }
      name         = "36''ʦ "
      type         = infantry
      strength     = 42
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 5 }
      name         = "4'˹'ɽʦ "
      type         = bergsjaeger
      strength     = 56
      max_strength = 70
    }
  }
  landunit =
  { location = 368 # Genova
    name     = "1žIII "
    id       = { type = 30026 id = 6 }
    division =
    { id           = { type = 30026 id = 7 }
      name         = "3''ʦ "
      type         = infantry
      strength     = 56
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 8 }
      name         = "6'ڰ'ʦ "
      type         = infantry
      strength     = 63
      max_strength = 70
    }
  }
  landunit =
  { location = 368 # Genova
    name     = "1žXV "
    id       = { type = 30026 id = 9 }
    division =
    { id           = { type = 30026 id = 10 }
      name         = "5''ʦ "
      type         = infantry
      strength     = 63
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 11 }
      name         = "37'Ħ'ʦ "
      type         = infantry
      strength     = 63
      max_strength = 70
    }
    division =
    { id            = { type = 30026 id = 12 }
      name          = "44'ī'ʦ "
      type          = infantry
      extra         = anti_tank
      brigade_model = 0
      strength      = 56
      max_strength  = 70
    }
  }
  landunit =
  { location = 371 # Trento
    name     = "1žԤ "
    id       = { type = 30026 id = 13 }
    division =
    { id           = { type = 30026 id = 14 }
      name         = "5'˹'ɽʦ "
      type         = bergsjaeger
      strength     = 49
      max_strength = 70
    }
  }
  landunit =
  { location = 371 # Trento
    name     = "4ž˹ "
    id       = { type = 30026 id = 15 }
    division =
    { id           = { type = 30026 id = 16 }
      name         = "1'ͼ˹'ɽʦ "
      type         = bergsjaeger
      strength     = 49
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 17 }
      name         = "2'׵ŵ'ɽʦ "
      type         = bergsjaeger
      strength     = 49
      max_strength = 70
    }
  }
  landunit =
  { location = 531 # Torino
    name     = "4žI "
    id       = { type = 30026 id = 18 }
    division =
    { id           = { type = 30026 id = 19 }
      name         = "1''ʦ "
      type         = infantry
      strength     = 42
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 20 }
      name         = "24'Ƥ³'ʦ "
      type         = infantry
      strength     = 35
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 21 }
      name         = "59''ʦ "
      type         = infantry
      strength     = 56
      max_strength = 70
    }
  }
  landunit =
  { location = 531 # Torino
    name     = "4žIV "
    id       = { type = 30026 id = 22 }
    division =
    { id           = { type = 30026 id = 23 }
      name         = "2'˹˹'ʦ "
      type         = infantry
      strength     = 35
      max_strength = 70
    }
    division =
    { id            = { type = 30026 id = 24 }
      name          = "26'ɪ'ʦ "
      type          = infantry
      extra         = artillery
      brigade_model = 1
      strength      = 35
      max_strength  = 70
    }
  }
  landunit =
  { location = 378 # Venezia
    name     = "2žV "
    id       = { type = 30026 id = 25 }
    division =
    { id           = { type = 30026 id = 26 }
      name         = "12''ʦ "
      type         = infantry
      strength     = 42
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 27 }
      name         = "15'Ī'ʦ "
      type         = infantry
      strength     = 42
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 28 }
      name         = "57'װ͵'ʦ "
      type         = infantry
      strength     = 35
      max_strength = 70
    }
  }
  landunit =
  { location = 378 # Venezia
    name     = "2žXI "
    id       = { type = 30026 id = 29 }
    division =
    { id           = { type = 30026 id = 30 }
      name         = "13''ʦ "
      type         = infantry
      strength     = 42
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 31 }
      name         = "14''ʦ "
      type         = infantry
      strength     = 35
      max_strength = 70
    }
  }
  landunit =
  { location = 378 # Venezia
    name     = "6ž "
    id       = { type = 30026 id = 32 }
    division =
    { id           = { type = 30026 id = 33 }
      name         = "1'ŷ¡ϡ'ʦ "
      type         = cavalry
      model        = 2
      strength     = 49
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 34 }
      name         = "2'Ŭ'ʦ "
      type         = cavalry
      model        = 2
      strength     = 49
      max_strength = 70
    }
    division =
    { id            = { type = 30026 id = 35 }
      name          = "3'˹'ʦ "
      type          = cavalry
      model         = 2
      extra         = artillery
      brigade_model = 1
      strength      = 49
      max_strength  = 70
    }
  }
  landunit =
  { location = 378 # Venezia
    name     = "6žе "
    id       = { type = 30026 id = 36 }
    division =
    { id           = { type = 30026 id = 37 }
      name         = "101'˹'ʦ "
      type         = motorized
      extra        = armored_car
      strength     = 56
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 38 }
      name         = "102''ʦ "
      type         = motorized
      strength     = 56
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 39 }
      name         = "132''װʦ "
      type         = light_armor
      model        = 0
      extra        = armored_car
      strength     = 56
      max_strength = 70
    }
  }
  landunit =
  { location = 378 # Venezia
    name     = "6ž "
    id       = { type = 30026 id = 40 }
    division =
    { id           = { type = 30026 id = 41 }
      name         = "9'ձȰ'ʦ "
      type         = cavalry
      model        = 3
      strength     = 49
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 42 }
      name         = "10'ƤΤ'ʦ "
      type         = cavalry
      model        = 3
      strength     = 42
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 43 }
      name         = "52''ʦ "
      type         = cavalry
      model        = 3
      extra        = armored_car
      strength     = 42
      max_strength = 70
    }
  }
  landunit =
  { location = 371 # Trento
    name     = "8žXIV "
    id       = { type = 30026 id = 44 }
    division =
    { id           = { type = 30026 id = 45 }
      name         = "32''ʦ "
      type         = infantry
      strength     = 49
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 46 }
      name         = "38''ʦ "
      type         = infantry
      strength     = 42
      max_strength = 70
    }
  }
  landunit =
  { location = 514 # Rimini
    name     = "8žVI "
    id       = { type = 30026 id = 47 }
    division =
    { id           = { type = 30026 id = 48 }
      name         = "18'ī'ʦ "
      type         = infantry
      strength     = 35
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 49 }
      name         = "49''ʦ "
      type         = infantry
      strength     = 49
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 50 }
      name         = "56''ʦ "
      type         = infantry
      strength     = 49
      max_strength = 70
    }
  }
  landunit =
  { location = 525 # Messina
    name     = "ϷžXII "
    id       = { type = 30026 id = 243 }
    division =
    { id           = { type = 30026 id = 51 }
      name         = "28'˹'ʦ "
      type         = infantry
      strength     = 49
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 52 }
      name         = "54'ǲ'ʦ "
      type         = infantry
      strength     = 70
      max_strength = 70
    }
  }
  landunit =
  { location = 534 # Sardegna
    name     = "ϷžXIII "
    id       = { type = 30026 id = 53 }
    division =
    { id           = { type = 30026 id = 54 }
      name         = "30''ʦ "
      type         = infantry
      strength     = 42
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 55 }
      name         = "31''ʦ "
      type         = infantry
      strength     = 42
      max_strength = 70
    }
  }
  landunit =
  { location = 523 # Tirana
    name     = "ָӲ "
    id       = { type = 30026 id = 56 }
    division =
    { id           = { type = 30026 id = 57 }
      name         = "19'άٲ'ʦ "
      type         = infantry
      strength     = 70
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 58 }
      name         = "23''ʦ "
      type         = infantry
      strength     = 70
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 59 }
      name         = "53''ʦ "
      type         = infantry
      strength     = 70
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 60 }
      name         = "3''ʦ "
      type         = bergsjaeger
      strength     = 63
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 61 }
      name         = "131''װʦ "
      type         = light_armor
      model        = 0
      extra        = armored_car
      strength     = 63
      max_strength = 70
    }
  }
  landunit =
  { location = 524 # Cosenza
    name     = "3žIX "
    id       = { type = 30026 id = 62 }
    division =
    { id           = { type = 30026 id = 63 }
      name         = "29'Ƥ'ʦ "
      type         = infantry
      strength     = 35
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 64 }
      name         = "47''ʦ "
      type         = infantry
      strength     = 56
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 65 }
      name         = "48''ʦ "
      type         = infantry
      strength     = 49
      max_strength = 70
    }
  }
  landunit =
  { location = 513 # Firenze
    name     = "7žVII "
    id       = { type = 30026 id = 70 }
    division =
    { id           = { type = 30026 id = 71 }
      name         = "20''ʦ "
      type         = infantry
      strength     = 56
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 72 }
      name         = "41''ʦ "
      type         = infantry
      strength     = 49
      max_strength = 70
    }
  }
  landunit =
  { location = 515 # Roma
    name     = "7žVIII "
    id       = { type = 30026 id = 73 }
    division =
    { id           = { type = 30026 id = 74 }
      name         = "21''ʦ "
      type         = infantry
      strength     = 56
      max_strength = 70
    }
    division =
    { id            = { type = 30026 id = 75 }
      name          = "51'Ү'ʦ "
      type          = infantry
      extra         = artillery
      brigade_model = 1
      strength      = 56
      max_strength  = 70
    }
  }
  landunit =
  { location = 399 # Rodi
    name     = "ٺȺ "
    id       = { type = 30026 id = 76 }
    division =
    { id           = { type = 30026 id = 77 }
      name         = "50'׼'ʦ "
      type         = infantry
      strength     = 70
      max_strength = 70
    }
  }
  landunit =
  { location = 932 # Tripoli
    name     = "5žX "
    id       = { type = 30026 id = 78 }
    division =
    { id           = { type = 30026 id = 79 }
      name         = "25''ʦ "
      type         = infantry
      strength     = 70
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 80 }
      name         = "55''ʦ "
      type         = infantry
      strength     = 70
      max_strength = 70
    }
  }
  landunit =
  { location = 919 # Tobruk
    name     = "5žXX "
    id       = { type = 30026 id = 81 }
    division =
    { id           = { type = 30026 id = 82 }
      name         = "17'ά'ʦ "
      type         = infantry
      strength     = 70
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 83 }
      name         = "27''ʦ "
      type         = infantry
      strength     = 35
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 84 }
      name         = "61''ʦ "
      type         = infantry
      strength     = 56
      max_strength = 70
    }
  }
  landunit =
  { location = 932 # Tripoli
    name     = "5žXXIII "
    id       = { type = 30026 id = 85 }
    division =
    { id           = { type = 30026 id = 86 }
      name         = "1'23'ʦ "
      type         = infantry
      strength     = 70
      max_strength = 70
      experience   = 30
    }
    division =
    { id           = { type = 30026 id = 87 }
      name         = "2'ʮ28'ʦ "
      type         = infantry
      strength     = 70
      max_strength = 70
      experience   = 30
    }
  }
  landunit =
  { location = 919 # Tobruk
    name     = "10žXXI "
    id       = { type = 30026 id = 88 }
    division =
    { id           = { type = 30026 id = 89 }
      name         = "62'￨'ʦ "
      type         = infantry
      strength     = 56
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 90 }
      name         = "63''ʦ "
      type         = infantry
      strength     = 56
      max_strength = 70
    }
  }
  landunit =
  { location = 924 # Bengazi
    name     = "10žXXII "
    id       = { type = 30026 id = 91 }
    division =
    { id           = { type = 30026 id = 92 }
      name         = "64'̹'ʦ "
      type         = infantry
      strength     = 56
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 93 }
      name         = "4'һ3'ʦ "
      type         = infantry
      strength     = 70
      max_strength = 70
      experience   = 30
    }
  }
  landunit =
  { location = 919 # Tobruk
    name     = "10žפ "
    id       = { type = 30026 id = 94 }
    division =
    { id           = { type = 30026 id = 95 }
      name         = "3'21'ʦ "
      type         = infantry
      strength     = 21
      max_strength = 70
      experience   = 30
    }
    division =
    { id           = { type = 30026 id = 96 }
      name         = "ʦ "
      type         = militia
      strength     = 10
      max_strength = 70
    }
  }
  landunit =
  { location = 1033 # Asmara
    name     = "Ǿ "
    id       = { type = 30026 id = 97 }
    division =
    { id           = { type = 30026 id = 98 }
      name         = "''ʦ "
      type         = infantry
      strength     = 63
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 99 }
      name         = "''ʦ "
      type         = militia
      strength     = 10
      max_strength = 70
    }
  }
  landunit =
  { location = 1039 # Massaua
    name     = "Ǿűפ "
    id       = { type = 30026 id = 100 }
    division =
    { id           = { type = 30026 id = 101 }
      name         = "ǵ1ʦ "
      type         = militia
      strength     = 49
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 102 }
      name         = "ǵ2ʦ "
      type         = militia
      strength     = 42
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 103 }
      name         = "ǵ4ʦ "
      type         = militia
      strength     = 42
      max_strength = 70
    }
  }
  landunit =
  { location = 1053 # Magalo
    name     = "Ǿϲפ "
    id       = { type = 30026 id = 104 }
    division =
    { id           = { type = 30026 id = 105 }
      name         = "ϲر "
      type         = militia
      strength     = 49
      max_strength = 70
    }
  }
  landunit =
  { location = 1047 # Macalle
    name     = "ǾŶפ "
    id       = { type = 30026 id = 106 }
    division =
    { id           = { type = 30026 id = 107 }
      name         = "ر "
      type         = militia
      strength     = 49
      max_strength = 70
    }
  }
  landunit =
  { location = 1056 # Mogadiscio
    name     = "Ǿפ "
    id       = { type = 30026 id = 108 }
    division =
    { id           = { type = 30026 id = 109 }
      name         = "101ʦ "
      type         = militia
      strength     = 28
      max_strength = 70
    }
    division =
    { id           = { type = 30026 id = 110 }
      name         = "102ʦ "
      type         = militia
      strength     = 21
      max_strength = 70
    }
  }
  # ###########################
  navalunit =
  { id       = { type = 30026 id = 111 }
    name     = " "
    location = 523
    base     = 523
    division =
    { id    = { type = 30026 id = 112 }
      name  = "ʥκ "
      type  = heavy_cruiser
      model = 0
    }
    division =
    { id    = { type = 30026 id = 113 }
      name  = "к "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 30026 id = 114 }
      name  = " "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 30026 id = 115 }
      name  = "2֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 30026 id = 116 }
      name  = "3֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 30026 id = 117 }
      name  = "4֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 30026 id = 118 }
      name  = "5֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 30026 id = 119 }
      name  = "6֧ "
      type  = destroyer
      model = 1
    }
  }
  # ##################################
  navalunit =
  { id       = { type = 30026 id = 120 }
    name     = "1 "
    location = 523
    base     = 523
    division =
    { id    = { type = 30026 id = 121 }
      name  = "¡ "
      type  = battleship
      model = 1
    }
  }
  navalunit =
  { id       = { type = 30026 id = 122 }
    name     = "1ӵ1ֶ "
    location = 523
    base     = 523
    division =
    { id    = { type = 30026 id = 129 }
      name  = " "
      type  = heavy_cruiser
      model = 2
    }
    division =
    { id    = { type = 30026 id = 130 }
      name  = "Ǻ "
      type  = heavy_cruiser
      model = 2
    }
    division =
    { id    = { type = 30026 id = 131 }
      name  = "ķ "
      type  = heavy_cruiser
      model = 2
    }
    division =
    { id    = { type = 30026 id = 132 }
      name  = "9֧ "
      type  = destroyer
      model = 1
    }
  }
  navalunit =
  { id       = { type = 30026 id = 133 }
    name     = "1ӵ4ֶ "
    location = 378
    base     = 378
    division =
    { id       = { type = 30026 id = 134 }
      name     = "￨ͱŵ "
      type     = light_cruiser
      model    = 1
      maxspeed = 34
    }
    division =
    { id    = { type = 30026 id = 135 }
      name  = "·׼ɺ "
      type  = light_cruiser
      model = 1
    }
    division =
    { id       = { type = 30026 id = 136 }
      name     = "Сŵ "
      type     = light_cruiser
      model    = 1
      maxspeed = 34
    }
    division =
    { id    = { type = 30026 id = 137 }
      name  = "¡Ⱥ "
      type  = light_cruiser
      model = 1
    }
    division =
    { id    = { type = 30026 id = 138 }
      name  = "12֧ "
      type  = destroyer
      model = 1
    }
  }
  navalunit =
  { id       = { type = 30026 id = 139 }
    name     = "1ӵ5ֶ "
    location = 378
    base     = 378
    division =
    { id    = { type = 30026 id = 140 }
      name  = "Ӹ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 30026 id = 141 }
      name  = "7֧ "
      type  = destroyer
      model = 2
    }
    division =
    { id    = { type = 30026 id = 142 }
      name  = "8֧ "
      type  = destroyer
      model = 2
    }
  }
  navalunit =
  { id       = { type = 30026 id = 143 }
    name     = "1ӵ8ֶ "
    location = 378
    base     = 378
    division =
    { id       = { type = 30026 id = 144 }
      name     = "³ "
      type     = light_cruiser
      model    = 3
      maxspeed = 35
    }
    division =
    { id       = { type = 30026 id = 145 }
      name     = "塤ﲨں "
      type     = light_cruiser
      model    = 3
      maxspeed = 35
    }
    division =
    { id    = { type = 30026 id = 146 }
      name  = "16֧ "
      type  = destroyer
      model = 2
    }
    division =
    { id    = { type = 30026 id = 147 }
      name  = "1䴬 "
      type  = transport
      model = 0
    }
  }
  navalunit =
  { id       = { type = 30026 id = 148 }
    name     = "1ӵ9ֶ "
    location = 378
    base     = 378
    division =
    { id    = { type = 30026 id = 149 }
      name  = "14֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 30026 id = 150 }
      name  = "15֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 30026 id = 151 }
      name  = "2䴬 "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 30026 id = 152 }
      name  = "6䴬 "
      type  = transport
      model = 0
    }
  }
  # ###################################
  navalunit =
  { id       = { type = 30026 id = 153 }
    name     = "2 "
    location = 523
    base     = 523
    division =
    { id    = { type = 30026 id = 154 }
      name  = " "
      type  = heavy_cruiser
      model = 2
    }
    division =
    { id    = { type = 30026 id = 155 }
      name  = "䴬 "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 30026 id = 156 }
      name  = "7䴬 "
      type  = transport
      model = 0
    }
  }
  navalunit =
  { id       = { type = 30026 id = 157 }
    name     = "2ӵ2ֶ "
    location = 523
    base     = 523
    division =
    { id       = { type = 30026 id = 158 }
      name     = "¡׺ "
      type     = light_cruiser
      model    = 1
      maxspeed = 34
    }
    division =
    { id       = { type = 30026 id = 159 }
      name     = "÷¡װ "
      type     = light_cruiser
      model    = 1
      maxspeed = 34
    }
    division =
    { id    = { type = 30026 id = 160 }
      name  = "10֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 30026 id = 161 }
      name  = "ɡ䴬 "
      type  = transport
      model = 0
    }
  }
  navalunit =
  { id       = { type = 30026 id = 162 }
    name     = "2ӵ3ֶ "
    location = 523
    base     = 523
    division =
    { id    = { type = 30026 id = 163 }
      name  = "к "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 30026 id = 164 }
      name  = "ŵ "
      type  = heavy_cruiser
      model = 2
    }
    division =
    { id    = { type = 30026 id = 165 }
      name  = "˹غ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 30026 id = 167 }
      name  = "11֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 30026 id = 168 }
      name  = "䴬 "
      type  = transport
      model = 0
    }
  }
  navalunit =
  { id       = { type = 30026 id = 169 }
    name     = "2ӵ7ֶ "
    location = 523
    base     = 523
    division =
    { id       = { type = 30026 id = 170 }
      name     = "ŷ "
      type     = light_cruiser
      model    = 2
      maxspeed = 34
    }
    division =
    { id       = { type = 30026 id = 171 }
      name     = "˹ "
      type     = light_cruiser
      model    = 2
      maxspeed = 34
    }
    division =
    { id       = { type = 30026 id = 172 }
      name     = "ĬȰ¡̹ "
      type     = light_cruiser
      model    = 2
      maxspeed = 34
    }
    division =
    { id       = { type = 30026 id = 173 }
      name     = "ɶࡤɵ¿ "
      type     = light_cruiser
      model    = 2
      maxspeed = 34
    }
    division =
    { id    = { type = 30026 id = 174 }
      name  = "13֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 30026 id = 175 }
      name  = "貨䴬 "
      type  = transport
      model = 0
    }
  }
  # #####################################
  navalunit =
  { id       = { type = 30026 id = 176 }
    name     = "ǱͧϽ "
    location = 369
    base     = 369
    division =
    { id    = { type = 30026 id = 177 }
      name  = "4֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 30026 id = 178 }
      name  = "51Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 30026 id = 179 }
      name  = "52Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
  }
  navalunit =
  { id       = { type = 30026 id = 180 }
    name     = "1Ǳͧ "
    location = 369
    base     = 369
    division =
    { id    = { type = 30026 id = 181 }
      name  = "11Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 30026 id = 182 }
      name  = "12Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 30026 id = 183 }
      name  = "13Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 30026 id = 184 }
      name  = "14Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 30026 id = 185 }
      name  = "17Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
  }
  navalunit =
  { id       = { type = 30026 id = 186 }
    name     = "3Ǳͧ "
    location = 369
    base     = 369
    division =
    { id    = { type = 30026 id = 187 }
      name  = "31Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
  }
  navalunit =
  { id       = { type = 30026 id = 188 }
    name     = "4Ǳͧ "
    location = 369
    base     = 369
    division =
    { id    = { type = 30026 id = 189 }
      name  = "40Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 30026 id = 190 }
      name  = "41Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 30026 id = 191 }
      name  = "42Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 30026 id = 192 }
      name  = "43Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
  }
  navalunit =
  { id       = { type = 30026 id = 193 }
    name     = "7Ǳͧ "
    location = 369
    base     = 369
    division =
    { id    = { type = 30026 id = 194 }
      name  = "71Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 30026 id = 195 }
      name  = "72Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
  }
  # #####################################################
  navalunit =
  { id       = { type = 30026 id = 196 }
    name     = "ǺָӲ "
    location = 932
    base     = 932
    division =
    { id    = { type = 30026 id = 197 }
      name  = "1֧ "
      type  = destroyer
      model = 1
    }
  }
  navalunit =
  { id       = { type = 30026 id = 198 }
    name     = "8Ǳͧ "
    location = 932
    base     = 932
    division =
    { id    = { type = 30026 id = 199 }
      name  = "61Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 30026 id = 200 }
      name  = "62Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
  }
  navalunit =
  { id       = { type = 30026 id = 201 }
    name     = "캣ָӲ "
    location = 1038
    base     = 1038
    division =
    { id    = { type = 30026 id = 202 }
      name  = "3֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 30026 id = 203 }
      name  = "5֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 30026 id = 204 }
      name  = "ΰ䴬 "
      type  = transport
      model = 0
    }
  }
  navalunit =
  { id       = { type = 30026 id = 205 }
    name     = "8Ǳͧ "
    location = 1038
    base     = 1038
    division =
    { id    = { type = 30026 id = 206 }
      name  = "81Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 30026 id = 207 }
      name  = "82Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
  }
  airunit =
  { location = 531 # Turin
    base     = 531
    id       = { type = 30026 id = 208 }
    name     = "1վ "
    division =
    { id       = { type = 30026 id = 209 }
      name     = "9߻ "
      strength = 100
      type     = interceptor
      model    = 0
    }
  }
  airunit =
  { location = 531
    base     = 531
    id       = { type = 30026 id = 210 }
    name     = "6''սը "
    division =
    { id       = { type = 30026 id = 211 }
      name     = "6''սը "
      strength = 100
      type     = tactical_bomber
      model    = 0
    }
  }
  airunit =
  { location = 531
    base     = 531
    id       = { type = 30026 id = 212 }
    name     = "2''߻ "
    division =
    { id       = { type = 30026 id = 213 }
      name     = "2''߻ "
      strength = 100
      type     = interceptor
      model    = 1
    }
  }
  airunit =
  { location = 919
    base     = 919
    id       = { type = 30026 id = 214 }
    name     = "4''սը "
    division =
    { id       = { type = 30026 id = 215 }
      name     = "4''սը "
      strength = 100
      type     = tactical_bomber
      model    = 1
    }
  }
  # ###############################
  airunit =
  { location = 523 # Taranto
    base     = 523
    id       = { type = 30026 id = 216 }
    name     = "2վ "
    division =
    { id       = { type = 30026 id = 217 }
      name     = "14'׿˹'߻ "
      strength = 100
      type     = interceptor
      model    = 0
    }
  }
  airunit =
  { location = 523
    base     = 523
    id       = { type = 30026 id = 218 }
    name     = "3''ը "
    division =
    { id       = { type = 30026 id = 219 }
      name     = "3''ը "
      strength = 100
      type     = tactical_bomber
      model    = 1
    }
    division =
    { id       = { type = 30026 id = 220 }
      name     = "24ը "
      strength = 50
      type     = tactical_bomber
      model    = 0
    }
  }
  airunit =
  { location = 523
    base     = 523
    id       = { type = 30026 id = 221 }
    name     = "ǵǺվ "
    division =
    { id       = { type = 30026 id = 222 }
      name     = "38սը "
      strength = 100
      type     = tactical_bomber
      model    = 0
    }
  }
  # ##################################
  airunit =
  { location = 525
    base     = 525
    id       = { type = 30026 id = 223 }
    name     = "3վ "
    division =
    { id       = { type = 30026 id = 224 }
      name     = "7߻ "
      strength = 100
      type     = interceptor
      model    = 1
    }
  }
  airunit =
  { location = 525
    base     = 525
    id       = { type = 30026 id = 225 }
    name     = "8'˹'߻ "
    division =
    { id       = { type = 30026 id = 226 }
      name     = "8'˹'߻ "
      strength = 100
      type     = interceptor
      model    = 0
    }
  }
  # #########################################
  airunit =
  { location = 378
    base     = 378
    id       = { type = 30026 id = 227 }
    name     = "4վ "
    division =
    { id       = { type = 30026 id = 228 }
      name     = "35սԺը "
      strength = 100
      type     = tactical_bomber
      model    = 1
    }
  }
  airunit =
  { location = 534
    base     = 534
    id       = { type = 30026 id = 229 }
    name     = "վ "
    division =
    { id       = { type = 30026 id = 230 }
      name     = "53߻ "
      strength = 100
      type     = interceptor
      model    = 1
    }
    division =
    { id       = { type = 30026 id = 231 }
      name     = "190ը "
      strength = 60
      type     = cas
      model    = 0
    }
    division =
    { id       = { type = 30026 id = 232 }
      name     = "50ը "
      strength = 50
      type     = cas
      model    = 0
    }
  }
  # ################################################
  airunit =
  { location = 932
    base     = 932
    id       = { type = 30026 id = 233 }
    name     = "ǿվ "
    division =
    { id       = { type = 30026 id = 234 }
      name     = "9߻ "
      strength = 100
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 30026 id = 235 }
      name     = "15/33սը "
      strength = 50
      type     = tactical_bomber
      model    = 0
    }
  }
  # ###########################################
  airunit =
  { location = 924
    base     = 924
    id       = { type = 30026 id = 236 }
    name     = "ǿվ "
    division =
    { id       = { type = 30026 id = 237 }
      name     = "33߻ "
      strength = 100
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 30026 id = 238 }
      name     = "13'ϼ'սԺը "
      strength = 100
      type     = tactical_bomber
      model    = 0
    }
  }
  division_development =
  { name  = "ǡǺ " 
    type  = battleship
    model = 2
    cost  = 8
    id    = { type = 30026 id = 239 }
    date  = { year = 1939 month = january day = 19 } #refit
  }
  division_development =
  { name  = "Լº "
    type  = battleship
    model = 2
    cost  = 8
    id    = { type = 30026 id = 240 }
    date  = { year = 1939 month = january day = 19 } #refit
  }
  division_development =
  { name  = "º "
    type  = battleship
    model = 3
    cost  = 10
    id    = { type = 30026 id = 241 }
    date  = { year = 1939 month = april day = 11 } #70% ready
  }
  division_development =
  { name  = "ά¡άк "
    type  = battleship
    model = 3
    cost  = 10
    id    = { type = 30026 id = 242 }
    date  = { year = 1939 month = april day = 13 } #70% ready
  }
}
